% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateBinomialP.R
\name{calculateBinomialP}
\alias{calculateBinomialP}
\title{calculate the probability, p, to conduct a binomial exact test}
\usage{
calculateBinomialP(L, percent_features)
}
\arguments{
\item{L}{the total number of features in X. Should be a positive integer >1}

\item{percent_features}{what percentage of L do we subsample at each tree? Should be a proportion between (0,1)}
}
\value{
If L is an integeter returns a probability value for selecting predictor Xj randomly
}
\description{
\code{calculateBinomialP} returns a probability of randomly selecting a feature as the root node in a decision tree. This is a generic function that is called internally in \code{binomialRF} but that may also be called directly if needed. The arguments \code{...}
should be, L= Total number of features in X, and percent_features= what percent of L is subsampled in the \code{randomForest} call.
}
\examples{
calculateBinomialP(110, .4)
calculateBinomialP(13200, .5)
}
