% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ThresholdDorfman.R
\name{TOD}
\alias{TOD}
\title{Summary measures for the Thresholded Optimal Dorfman (TOD) algorithm}
\usage{
TOD(p.vec, Se, Sp, max = 15, init.group.sz = NULL, threshold = NULL)
}
\arguments{
\item{p.vec}{a vector of individual risk probabilities.}

\item{Se}{sensitivity of the diagnostic test.}

\item{Sp}{specificity of the diagnostic test.}

\item{max}{the maximum allowable group size. Further details are given under
'Details'.}

\item{init.group.sz}{the initial group size used for TOD, if \kbd{threshold}
is not specified. Further details are given under 'Details'.}

\item{threshold}{the threshold value for TOD. If a threshold is not
specified, one is found algorithmically. Further details are given under
'Details'.}
}
\value{
A list containing:
\item{prob}{the vector of individual risk probabilities, as specified
by the user.}
\item{Se}{the sensitivity of the diagnostic test, as specified by the user.}
\item{Sp}{the specificity of the diagnostic test, as specified by the user.}
\item{group.sz}{the initial group size used for TOD, if applicable.}
\item{thresh.val}{the threshold value used for TOD, if applicable.}
\item{OTC}{a list specifying elements of the optimal testing configuration,
which may include:
\describe{
\item{Block.sz}{the block size/initial group size for informative Dorfman
testing, which is not tested.}
\item{pool.szs}{group sizes for the first stage of testing for informative
Dorfman testing.}}}
\item{ET}{the expected testing expenditure to decode all individuals in the
algorithm.}
\item{Var}{the variance of the testing expenditure to decode all individuals
in the algorithm.}
\item{Accuracy}{a list containing:
\describe{
\item{Individual}{a matrix of accuracy measures for each individual.
The rows correspond to each unique set of accuracy
measures in the algorithm. Individuals with the same set of accuracy
measures are displayed together in a single row of the matrix. The columns
correspond to the pool index, the individual risk probability, and the
pooling sensitivity, pooling specificity, pooling positive predictive value,
and pooling negative predictive value for the individuals in each row of the
matrix.}
\item{Overall}{a matrix of overall accuracy measures for the algorithm.
The columns correspond to the pooling sensitivity, pooling specificity,
pooling positive predictive value, and pooling negative predictive value
for the overall algorithm. Further details are given under 'Details'.}}}
}
\description{
Summary measures for the Thresholded Optimal Dorfman (TOD)
algorithm.
}
\details{
This function finds the characteristics of an informative two-stage
hierarchical (Dorfman) decoding process. Characteristics found include the
expected expenditure of the decoding process, the variance of the expenditure
of the decoding process, and the pooling sensitivity, pooling specificity,
pooling positive predictive value, and pooling negative predictive value for
each individual and for the overall algorithm. Calculations of these
characteristics are done using equations presented in McMahan et al. (2012).

Thresholded Optimal Dorfman (TOD) is an informative Dorfman algorithm in
which all \eqn{N} individuals are partitioned into two classes, low-risk and
high-risk individuals. The threshold can be specified using the optional
\kbd{threshold} argument. Alternatively, the TOD algorithm can identify
the optimal threshold value. The low-risk individuals are tested using an
optimal common pool size, and the high-risk individuals are tested
individually. If desired, the user can add the constraint of a maximum
allowable group size (\kbd{max}), so that each group will contain no more
than the maximum allowable number of individuals.

The displayed overall pooling sensitivity, pooling specificity, pooling
positive predictive value, and pooling negative predictive value are
weighted averages of the corresponding individual accuracy measures for all
individuals within the initial group (or block) for a hierarchical
algorithm, or within the entire array for an array-based algorithm.
Expressions for these averages are provided in the Supplementary
Material for Hitt et al. (2019). These expressions are based on accuracy
definitions given by Altman and Bland (1994a, 1994b).
}
\examples{
# Example 1: Find the characteristics of an informative
#   Dorfman algorithm, using the TOD procedure.
set.seed(1002)
p.vec <- expectOrderBeta(p = 0.01, alpha = 2, size = 20)
TOD(p = p.vec, Se = 0.95, Sp = 0.95, max = 5,
    threshold = 0.015)

# Example 2: Find the threshold value for the TOD
#   procedure algorithmically. Then, find
#   characteristics of the algorithm.
TOD(p = p.vec, Se = 0.95, Sp = 0.95, max = 5,
    init.group.sz = 10)
}
\references{
\insertRef{Altman1994a}{binGroup2}

\insertRef{Altman1994b}{binGroup2}

\insertRef{Hitt2019}{binGroup2}

\insertRef{McMahan2012a}{binGroup2}
}
\seealso{
\code{\link{expectOrderBeta}} for generating a vector of individual risk
probabilities.

Other operating characteristic functions: 
\code{\link{Sterrett}()},
\code{\link{halving}()},
\code{\link{operatingCharacteristics1}()},
\code{\link{operatingCharacteristics2}()}
}
\author{
Brianna D. Hitt
}
\concept{operating characteristic functions}
