% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inf.D3.R
\name{Inf.D3}
\alias{Inf.D3}
\title{Informative three-stage hierarchical testing}
\usage{
Inf.D3(p, Se, Sp, group.sz, obj.fn, weights, alpha)
}
\arguments{
\item{p}{the probability of disease, which can be an overall probability of disease,
from which a heterogeneous vector of individual probabilities will be generated, or
a vector of individual probabilities specified by the user}

\item{Se}{the sensitivity of the diagnostic test}

\item{Sp}{the specificity of the diagnostic test}

\item{group.sz}{a single group size over which to find the optimal testing
configuration out of all possible configurations, or a range of group sizes
over which to find the optimal testing configuration}

\item{obj.fn}{a list of objective functions which are minimized to find the
optimal testing configuration. Available options include "\kbd{ET}" (the expected
number of tests per individual), "\kbd{MAR}" (the expected number of tests divided
by the expected number of correct classifications, described in Malinovsky et al. (2016)),
\url{http://www.chrisbilder.com/grouptesting/HBTM/} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. Each set of
weights is specified by a row of the matrix.}

\item{alpha}{a scale parameter for the beta distribution that specifies the degree of
heterogeneity for the generated probability vector}
}
\value{
A list containing:
\item{prob}{the overall probability of disease or vector of individual probabilities, as specified by the user}
\item{alpha}{the level of heterogeneity used to generate the vector of individual probabilities}
\item{Se}{the sensitivity of the diagnostic test}
\item{Sp}{the specificity of the diagnostic test}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified by the user, containing:
\describe{
\item{OTC}{a list specifying the optimal testing configuration, which includes:
\describe{
\item{Stage1}{the pool size for the first stage of testing, i.e. the initial group size}
\item{Stage2}{pool sizes for the second stage of testing}}}
\item{p.vec}{the sorted vector of individual probabilities}
\item{ET}{the expected testing expenditure for the OTC}
\item{value}{the value of the objective function per individual}
\item{PSe}{the overall pooling sensitivity for the algorithm}
\item{PSp}{the overall pooling specificity for the algorithm}
\item{PPPV}{the overall pooling positive predictive value for the algorithm}
\item{PNPV}{the overall pooling negative predictive value for the algorithm}}}
}
\description{
Find the optimal testing configuration for informative
three-stage hierarchical testing and calculate the associated
operating charcteristics.
}
\details{
This function finds the optimal testing configuration and
computes the associated operating characteristics for informative
three-stage hierarchical testing. This function finds the optimal
testing configuration by considering all possible configurations.
See Hitt et al. (2018) at \url{http://www.chrisbilder.com/grouptesting/HBTM/}
or Black et al. (2015) for additional details.
}
\examples{
# Find the optimal testing configuration for information three-stage
#   hierarchical testing
Inf.D3(p=0.05, Se=0.99, Sp=0.99, group.sz=10:15, obj.fn=c("ET", "MAR"),
weights=NULL, alpha=0.5)

# Find the optimal testing configuration out of all possible configurations
#   for a specified group size and vector of individual probabilities
set.seed(82763)
Inf.D3(p=rbeta(12,2,200), Se=0.99, Sp=0.99, group.sz=12,
obj.fn=c("ET", "MAR", "GR"),
weights=matrix(data=c(1,1), nrow=1, ncol=2, byrow=TRUE),
alpha=NA)

}
\references{
\emph{Black, M.S.; Bilder, C.R. & Tebbs, J.M. (2015)}.
Optimal retesting configurations for hierarchical group testing.
\emph{Journal of the Royal Statistical Society. Series C: Applied Statistics,
64, 693-710}.

\emph{Graff, L.E. & Roeloffs, R. (1972)}. Group testing in the presence of
test error; an extension of the Dorfman procedure. \emph{Technometrics, 14, 113-122}.

\emph{Malinovsky, Y.; Albert, P.S. & Roy, A. (2016)}. Reader reaction: A note on the
evaluation of group testing algorithms in the presence of misclassification.
\emph{Biometrics, 72, 299-302}.
}
\seealso{
\code{\link{NI.D3}} for non-informative three-stage hierarchical testing

\code{\link{OTC}} for finding the optimal testing configuration for a
number of standard group testing algorithms

\url{http://chrisbilder.com/grouptesting/HBTM}

Other Optimal Testing Configuration functions: \code{\link{Inf.Array}},
  \code{\link{Inf.Dorf}}, \code{\link{NI.A2M}},
  \code{\link{NI.Array}}, \code{\link{NI.D3}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna Hitt
}
