% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_labs.R
\name{bb_labs}
\alias{bb_labs}
\title{Quickly set title, axis labels and caption}
\usage{
bb_labs(
  bb,
  title = NULL,
  x = NULL,
  y = NULL,
  caption = NULL,
  caption_href = NULL
)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{title}{Text for the chart title, use \code{\\n} to make a new line.}

\item{x}{Text for x axis title.}

\item{y}{Text for y axis title.}

\item{caption}{Text for the caption displayed in the bottom-right of the chart.}

\item{caption_href}{Associate the caption with a link to an URL.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Quickly set title, axis labels and caption
}
\note{
\code{caption} is not part of the billboard.js library, it is added by the \code{billboarder} package.
}
\examples{
data("prod_par_filiere")

billboarder() \%>\%
  bb_barchart(
    data = prod_par_filiere[, c("annee", "prod_hydraulique")],
    color = "#102246"
  ) \%>\%
  bb_legend(show = FALSE) \%>\%
  bb_labs(
    title = "French hydraulic production",
    y = "production (in terawatt-hours)",
    caption = "Data source: RTE (https://opendata.reseaux-energies.fr/)",
    caption_href = "https://opendata.reseaux-energies.fr/"
  )
}
