% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_radar}
\alias{bb_radar}
\title{Radar property for a Billboard.js chart}
\usage{
bb_radar(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.radar}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Radar property for a Billboard.js chart
}
\examples{
library("billboarder")
data("avengers")

# number of levels
billboarder() \%>\%
  bb_radarchart(
    data = avengers,
    mapping = bbaes(x = axis, y = value, group = group)
  ) \%>\% 
  bb_radar(level = list(depth = 4))

# hide levels
billboarder() \%>\%
  bb_radarchart(
    data = avengers,
    mapping = bbaes(x = axis, y = value, group = group)
  ) \%>\% 
  bb_radar(level = list(show = FALSE))

# max value on axis
billboarder() \%>\%
  bb_radarchart(
    data = avengers,
    mapping = bbaes(x = axis, y = value, group = group)
  ) \%>\% 
  bb_radar(axis = list(max = 10))
}
