% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/database-stats.R
\name{bike_datelimits}
\alias{bike_datelimits}
\title{Extract date-time limits from trip database}
\usage{
bike_datelimits(bikedb, city)
}
\arguments{
\item{bikedb}{A string containing the path to the SQLite3 database.
If no directory specified, it is presumed to be in \code{tempdir()}.}

\item{city}{If given, date limits are calculated only for trips in 
that city.}
}
\value{
A vector of 2 elements giving the date-time of the first and last
trips
}
\description{
Extract date-time limits from trip database
}
\examples{
data_dir <- tempdir ()
bike_write_test_data (data_dir = data_dir)
# dl_bikedata (city = 'la', data_dir = '.') # or download some real data!
bikedb <- file.path (data_dir, 'testdb')
store_bikedata (data_dir = data_dir, bikedb = bikedb)
# create database indexes for quicker access:
index_bikedata_db (bikedb = bikedb)

bike_datelimits ('testdb') # overall limits for all cities
bike_datelimits ('testdb', city = 'NYC') 
bike_datelimits ('testdb', city = 'los angeles') 

bike_rm_test_data (data_dir = data_dir)
bike_rm_db (bikedb)
# don't forget to remove real data!
# file.remove (list.files ('.', pattern = '.zip'))
}
