% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce.R
\name{reduce_matrix}
\alias{reduce_matrix}
\title{Reducing number of variables}
\usage{
reduce_matrix(data, minpv = 0.15)
}
\arguments{
\item{data}{an object of class \code{big}.}

\item{minpv}{a numeric. Variables with p-values for the Pearson correlation
tests larger than \code{minpv} will be removed from \code{candidates}.}
}
\value{
An object of class \code{big}.
}
\description{
Perform the Pearson correlation tests between a vector \code{y} and every
variable from a matrix \code{X} (separately) and remove uncorrelated
variables. The function is much faster when you do not have any missing
values (set \code{na = FALSE} in \code{prepare_data} in that case).
}
\details{
Type \code{browseVignettes("bigstep")} for more details.
}
\examples{
set.seed(1)
n <- 30
p <- 10
X <- matrix(rnorm(n * p), ncol = p)
y <- X[, 2] + 2*X[, 3] - X[, 6] + rnorm(n)
d <- prepare_data(y, X)
reduce_matrix(d)

}
