% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biglasso.R
\name{COPY_biglasso_part}
\alias{COPY_biglasso_part}
\title{Train one model}
\usage{
COPY_biglasso_part(X, y.train, ind.train, ind.col, covar.train, family,
  lambda, center, scale, resid, alpha, eps, max.iter, dfmax, warn, ind.val,
  covar.val, y.val, n.abort, nlam.min, b0, base.train, base.val)
}
\value{
A named list with following variables:
\item{intercept}{A vector of intercepts, corresponding to each lambda.}
\item{beta}{The vector of coefficients that minimized the loss on the
validation set.}
\item{iter}{A vector of length \code{nlambda} containing the number of
iterations until convergence at each value of \code{lambda}.}
\item{lambda}{The sequence of regularization parameter values in the path.}
\item{family}{Either \code{"gaussian"} or \code{"binomial"} depending on the
function used.}
\item{alpha}{Input parameter.}
\item{loss}{A vector containing either the residual sum of squares
(for linear models) or negative log-likelihood (for logistic models)
of the fitted model at each value of \code{lambda}.}
\item{loss.val}{A vector containing the loss for the corresponding
validation set.}
\item{n}{The number of observations used in the model fitting. It's equal
to \code{length(row.idx)}.}
\item{p}{The number of dimensions (including covariables,
but not the intercept).}
\item{center}{The sample mean vector of the variables, i.e., column mean
of the sub-matrix of \code{X} used for model fitting.}
\item{scale}{The sample standard deviation of the variables, i.e.,
column standard deviation of the sub-matrix of \code{X} used for model
fitting.}
\item{y}{The response vector used in the model fitting. Depending on
\code{row.idx}, it could be a subset of the raw input of the response vector
y.}
\item{col.idx}{The indices of features that have 'scale' value greater
than \code{1e-6}. Features with 'scale' less than 1e-6 are removed from
model fitting.}
}
\description{
Train one model
}
\keyword{internal}
