% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biginteger.R
\name{biginteger}
\alias{biginteger}
\alias{as_biginteger}
\alias{is_biginteger}
\title{Arbitrary-Precision Integer Vectors}
\usage{
biginteger(x = character())

as_biginteger(x)

is_biginteger(x)
}
\arguments{
\item{x}{Object to be coerced or tested.}
}
\value{
An S3 vector of class \code{bignum_biginteger}.
}
\description{
\code{biginteger()} and \code{as_biginteger()} construct a vector designed to store
\emph{any} integer.

\code{is_biginteger()} checks if an object is of class \code{bignum_biginteger}.
}
\examples{
# default options limit displayed precision
biginteger(2)^50L

# display full precision
format(biginteger(2)^50L, notation = "dec")

# lossy casts raise a warning
biginteger(c(2, 2.5, 3))

# suppress warnings if they are expected
suppressWarnings(biginteger(c(2, 2.5, 3)))

# unsigned integers can be specified as hexadecimal
biginteger("0xffffffff")
}
\seealso{
\code{\link{NA_biginteger_}} to represent missing values.

\code{\link[=format.bignum_biginteger]{format()}} for pretty printing.

\code{vignette("operations")} for supported operations.
}
