% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surface_conditions.r
\name{radiometric.surface.temp}
\alias{radiometric.surface.temp}
\title{Radiometric Surface Temperature}
\usage{
radiometric.surface.temp(data, LW_up = "LW_up", LW_down = "LW_down",
  emissivity, constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required input variables}

\item{LW_up}{Longwave upward radiation (W m-2)}

\item{LW_down}{Longwave downward radiation (W m-2)}

\item{emissivity}{Emissivity of the surface (-)}

\item{constants}{sigma - Stefan-Boltzmann constant (W m-2 K-4) \cr
Kelvin - conversion degree Celsius to Kelvin}
}
\value{
a data.frame with the following columns:
        \item{Trad_K}{Radiometric surface temperature (K)} \cr
        \item{Trad_degC}{Radiometric surface temperature (degC)}
}
\description{
Radiometric surface temperature from longwave radiation
             measurements.
}
\details{
Radiometric surface temperature (Trad) is calculated as:

           \deqn{Trad = ((LW_up - (1 - \epsilon)*LW_down) / (\sigma \epsilon))^(1/4)}
}
\examples{
# determine radiometric surface temperature for the site DE-Tha in June 2014 
# assuming an emissivity of 0.98.
# (Note that variable 'LW_down' was only included for the DE-Tha example dataset
# and not for the others due restrictions on file size) 
Trad <- radiometric.surface.temp(DE_Tha_Jun_2014,emissivity=0.98)
summary(Trad)

}
\references{
Wang, W., Liang, S., Meyers, T. 2008: Validating MODIS land surface
            temperature products using long-term nighttime ground measurements.
            Remote Sensing of Environment 112, 623-635.
}
