% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{pressure.from.elevation}
\alias{pressure.from.elevation}
\title{Atmospheric Pressure from Hypsometric Equation}
\usage{
pressure.from.elevation(elev, Tair, VPD = NULL,
  constants = bigleaf.constants())
}
\arguments{
\item{elev}{Elevation a.s.l. (m)}

\item{Tair}{Air temperature (deg C)}

\item{VPD}{Vapor pressure deficit (kPa); optional}

\item{constants}{Kelvin- conversion degC to Kelvin \cr
pressure0 - reference atmospheric pressure at sea level (Pa) \cr
Rd - gas constant of dry air (J kg-1 K-1) \cr
g -  gravitational acceleration (m s-2) \cr}
}
\value{
\item{pressure -}{Atmospheric pressure (kPa)}
}
\description{
An estimate of mean pressure at a given elevation as predicted by the
             hypsometric equation.
}
\details{
Atmospheric pressure is approximated by the hypsometric equation:

         \deqn{pressure = pressure_0 / (exp(g * elevation / (Rd Temp)))}
}
\note{
The hypsometric equation gives an estimate of the standard pressure
      at a given altitude. 
      If VPD is provided, humidity correction is applied and the
      virtual temperature instead of air temperature is used. VPD is 
      internally converted to specific humidity.
}
\examples{
# mean pressure at 500m altitude at 25 deg C and VPD of 1 kPa
pressure.from.elevation(500,Tair=25,VPD=1)

}
\references{
Stull B., 1988: An Introduction to Boundary Layer Meteorology.
            Kluwer Academic Publishers, Dordrecht, Netherlands.
}
