% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_subgraphs.R
\name{connect_subgraphs}
\alias{connect_subgraphs}
\title{Merge disjoint connected subgraphs}
\usage{
connect_subgraphs(carto, ID.area = NULL, nb = NULL, plot = FALSE)
}
\arguments{
\item{carto}{object of class \code{SpatialPolygonsDataFrame} or \code{sf}.}

\item{ID.area}{character vector of geographic identifiers.}

\item{nb}{optional argument with the neighbours list of class \code{nb}.
If \code{NULL} (default), this object is computed from the \code{carto} argument.}

\item{plot}{logical value (default \code{FALSE}), if \code{TRUE} then the computed neighbourhood graph is ploted.}
}
\value{
This function returns a list with the following two elements:
\itemize{
  \item \code{nb}: the modified neighbours list
  \item \code{W}: associated spatial adjacency matrix of class \code{CsparseMatrix}
}
}
\description{
The function returns a neighbour list of class \code{nb} and its associated spatial adjacency matrix
computed by merging disjoint connected subgraphs through its nearest polygon centroids.
}
\details{
This function first calls the \code{\link{add_neighbour}} function to search for isolated areas.
}
\examples{
library(spdep)

## Load the Spain colorectal cancer mortality data ##
data(Carto_SpainMUN)

## Select the polygons (municipalities) of the 'Comunidad Valenciana' region ##
carto <- Carto_SpainMUN[Carto_SpainMUN$region=="Comunidad Valenciana",]

carto.nb <- poly2nb(carto)
n.comp.nb(carto.nb)$nc # 2 disjoint connected subgraphs

## Plot the spatial polygons and its neighbourhood graph
op <- par(mfrow=c(1,2), pty="s")

plot(carto$geometry, main="Original neighbourhood graph")
plot(carto.nb, st_centroid(st_geometry(carto), of_largest_polygon=TRUE),
     pch=19, cex=0.5, col="red", add=TRUE)

## Use the 'connect_subgraphs' function ##
carto.mod <- connect_subgraphs(carto=carto, ID.area="ID", nb=carto.nb, plot=TRUE)
title(main="Modified neighbourhood graph")

n.comp.nb(carto.mod$nb)$nc==1

par(op)

}
