% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdt_locales.R
\docType{data}
\name{fdt_locales_lst}
\alias{fdt_locales_lst}
\title{A list of all supported locales}
\format{
An object of class \code{list} of length 574.
}
\usage{
fdt_locales_lst
}
\value{
A list where each element corresponds to a supported locale ID.
}
\description{
The \code{fdt_locales_lst} object is a list of all supported locales. This is
useful when used with the \code{\link[=fdt]{fdt()}} function as the list can be auto-completed
with a locale identifier and this generates valid input for the \code{locale}
argument.
}
\section{Examples}{


The \code{fdt_locales_lst} object can be incredibly useful when choosing one of
supported locales. You can avoid typing errors and every element of the list
is meant to work. In this example, we'll use the \code{"da"} locale through
use of the list.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = "yy-MMMM-d",
  locale = fdt_locales_lst$da
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "18-juli-4"
}\if{html}{\out{</div>}}
}

\keyword{datasets}
