% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.bca.ci.R
\name{boot.bca.ci}
\alias{boot.bca.ci}
\title{Bias-Corrected and Accelerated bootstrap Confidence Interval (BCa) Function.}
\usage{
boot.bca.ci(z, p, B = 99, J = 2, conf.level = 0.95)
}
\arguments{
\item{z}{a numeric vector containing the tree data.}

\item{p}{an integer determining the order of bifurcating autoregressive model to be fit to the data.}

\item{B}{number of bootstrap samples (replicates). Defaults to 99.}

\item{J}{an integer determining the number of vectors of bootstrap replicates. Defaults to 2.}

\item{conf.level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
\item{coef}{a matrix containing the least squares estimates of the autoregressive
coefficients}\item{limits}{A numeric vector representing the lower and upper limits of the BCa
confidence interval for the autoregressive coefficients of BAR model}
}
\description{
This function calculates the Bias-Corrected and Accelerated bootstrap (BCa)
CI for the least squares estimator of the bifurcating autoregressive model.
}
\examples{
# Generating Non-contaminated normal BAR(1) tree and calculating the BCa CI for
# the autoregressive coefficients of the BAR(1) model
z <- bfa.tree.gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
boot.bca.ci(z,p=1,B=99,J=2,conf.level=0.95)
# Generating Non-contaminated normal BAR(2) tree and calculating the BCa CI for
# the autoregressive coefficients of the BAR(2) model
z <- bfa.tree.gen(127, 2, 1, 1, 0.5, 0.5, 0, 10, c(0.5, 0.3))
boot.bca.ci(z,p=2,B=99,J=2,conf.level=0.95)
}
