% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.biclustermd_sse.R
\name{autoplot.biclustermd_sse}
\alias{autoplot.biclustermd_sse}
\title{Plot sums of squared errors (SSEs) consecutive biclustering iterations.}
\usage{
\method{autoplot}{biclustermd_sse}(object, ...)
}
\arguments{
\item{object}{Object of class "biclustermd_sse" with columns "Iteration" and "SSE"}

\item{...}{Arguments to pass to \code{ggplot2::geom_point()}}
}
\value{
A ggplot object.
}
\description{
Creates a ggplot of the decrease in SSE recorded in \code{biclustermd::bicluster()}.
}
\examples{
data("synthetic")

bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
bc
autoplot(bc$SSE)
}
