% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cochrane2df.R
\name{cochrane2df}
\alias{cochrane2df}
\title{Convert a Cochrane Database Export file into a data frame}
\usage{
cochrane2df(D)
}
\arguments{
\item{D}{is a character array containing data read from a ISI Export file (in plain text format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original ISI file.
}
\description{
It converts a Cochrane Database Export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A group of Cochrane Database Export files can be read using \\code{\\link{readFiles}} function:

# largechar <- readFiles('filename1.txt','filename2.txt','filename3.txt')

# filename.txt is a Cochrane Database Export file in plain text format.

# scientometrics_text <- readFiles('http://www.bibliometrix.org/datasets/cochrane.txt')
# scient_df <- cochrane2df(cochrane_text)

}
\seealso{
\code{\link{scopus2df}} for converting SCOPUS Export file (in bibtex format)

Other converting functions: \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{isibib2df}},
  \code{\link{pubmed2df}}, \code{\link{scopus2df}}
}
