% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseKOS_functions.R
\name{SelectParams}
\alias{SelectParams}
\title{Generates parameters.}
\usage{
SelectParams(TrainData, TrainCat, Sigma = NULL, Gamma = NULL,
  Epsilon = 1e-05)
}
\arguments{
\item{TrainData}{(n x p) Matrix of training data with numeric features. Cannot have missing values.}

\item{TrainCat}{(n x 1) Vector of class membership. Values must be either 1 or 2.}

\item{Sigma}{Scalar Gaussian kernel parameter. Default set to NULL and is automatically generated if user-specified value not provided. Must be > 0. User-specified parameters must satisfy hierarchical ordering.}

\item{Gamma}{Scalar ridge parameter used in kernel optimal scoring. Default set to NULL and is automatically generated if user-specified value not provided. Must be > 0. User-specified parameters must satisfy hierarchical ordering.}

\item{Epsilon}{Numerical stability constant with default value 1e-05. Must be > 0 and is typically chosen to be small.}
}
\value{
A list of 
\item{Sigma}{ Gaussian kernel parameter.}  
\item{Gamma}{ Ridge Parameter.}
\item{Lambda}{ Sparsity parameter.}
}
\description{
Generates parameters to be used in sparse kernel optimal scoring.
}
\details{
Generates the gaussian kernel, ridge, and sparsity parameters for use in sparse kernel optimal scoring using the methods presented in [Lapanowski and Gaynanova, preprint]. 
The Gaussian kernel parameter is generated using five-fold cross-validation of the misclassification error rate aross the {.05, .1, .2, .3, .5} quantiles of squared-distances between groups. 
The ridge parameter is generated using a stabilization technique developed in Lapanowski and Gaynanova (2019).
The sparsity parameter is generated by five-fold cross-validation over a logarithmic grid of 20 values in an automatically-generated interval.
}
\examples{
\donttest{
Sigma <- 1.325386  #Set parameter values equal to result of SelectParam.
Gamma <- 0.07531579 #Speeds up example

TrainData <- KOS_Data$TrainData
TrainCat <- KOS_Data$TrainCat

SelectParams(TrainData = TrainData , 
             TrainCat = TrainCat, 
             Sigma = Sigma, 
             Gamma = Gamma)
}
}
\references{
Lancewicki, Tomer. "Regularization of the kernel matrix via covariance matrix shrinkage estimation." arXiv preprint arXiv:1707.06156 (2017).

Lapanowski, Alexander F., and Gaynanova, Irina. ``Sparse feature selection in kernel discriminant analysis via optimal scoring'', Artificial Intelligence and Statistics, 2019.
}
