% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximum_pseudolikelihood.R
\name{mple}
\alias{mple}
\title{Maximum Pseudolikelihood Estimation for an Ordinal Markov Random Field Model}
\usage{
mple(
  x,
  convergence_criterion = sqrt(.Machine$double.eps),
  maximum_iterations = 1000,
  thresholds,
  interactions
)
}
\arguments{
\item{x}{A dataframe or matrix with \code{n} rows and \code{p} columns,
containing binary and ordinal variables for \code{n} independent observations
and \code{p} variables in the network. Variables are recoded as non-negative
integers \code{(0, 1, ..., m)} if not done already. Unobserved categories are
collapsed into other categories after recoding. See \code{reformat_data} for
details.}

\item{convergence_criterion}{The convergence criterion for the
pseudoposterior values in the EM algorithm. Defaults to
\code{sqrt(.Machine$double.eps)}.}

\item{maximum_iterations}{The maximum number of EM iterations used. Defaults
to \code{1e3}. A warning is issued if the procedure has not converged in
\code{maximum_iterations} iterations.}

\item{thresholds}{A matrix with \code{p} rows and \code{max(m)} columns,
containing the category thresholds for each node. Used as starting values in
the Newton-Raphson procedure. Optional.}

\item{interactions}{A matrix with \code{p} rows and \code{p} columns,
containing the pairwise association estimates in the off-diagonal elements.
Used as starting values in the Newton-Raphson procedure. Optional.}
}
\value{
A list containing:
\itemize{
\item \code{interactions}: A matrix with \code{p} rows and \code{p} columns,
containing the maximum pseudolikelihood estimates of the pairwise
associations in the off-diagonal elements.
\item \code{thresholds}: A matrix with \code{p} rows and \code{max(m)}
columns, containing the maximum pseudolikelihood estimates of the category
thresholds for each node.
}
}
\description{
The function \code{mple} estimates the parameters for the ordinal MRF
by optimizing the joint pseudolikelihood with the Newton-Raphson method.
}
