% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcsinh_x.R
\name{arcsinh_x}
\alias{arcsinh_x}
\alias{predict.arcsinh_x}
\alias{print.arcsinh_x}
\title{arcsinh(x) Transformation}
\usage{
arcsinh_x(x, standardize = TRUE)

\method{predict}{arcsinh_x}(object, newdata = NULL, inverse = FALSE, ...)

\method{print}{arcsinh_x}(x, ...)
}
\arguments{
\item{x}{A vector to normalize with with x}

\item{standardize}{If TRUE, the transformed values are also centered and
scaled, such that the transformation attempts a standard normal}

\item{object}{an object of class 'arcsinh_x'}

\item{newdata}{a vector of data to be (potentially reverse) transformed}

\item{inverse}{if TRUE, performs reverse transformation}

\item{...}{additional arguments}
}
\value{
A list of class \code{arcsinh_x} with elements 
\item{x.t}{transformed 
  original data} 
  \item{x}{original data} 
  \item{mean}{mean after transformation but prior to standardization} 
  \item{sd}{sd after transformation but prior to standardization} 
  \item{n}{number of nonmissing observations}
  \item{norm_stat}{Pearson's P / degrees of freedom}
  \item{standardize}{was the transformation standardized}
  
  The \code{predict} function returns the numeric value of the transformation
  performed on new data, and allows for the inverse transformation as well.
}
\description{
Perform a arcsinh(x) transformation
}
\details{
\code{arcsinh_x} performs an arcsinh transformation in the context of 
bestNormalize, such that it creates a transformation that can be estimated
and applied to new data via the \code{predict} function. 

The function is explicitly: log(x + sqrt(x^2 + 1))
}
\examples{
x <- rgamma(100, 1, 1)

arcsinh_x_obj <- arcsinh_x(x)
arcsinh_x_obj
p <- predict(arcsinh_x_obj)
x2 <- predict(arcsinh_x_obj, newdata = p, inverse = TRUE)

all.equal(x2, x)

}
