% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitize.R
\name{sanitize_model.glm}
\alias{sanitize_model.glm}
\title{(internal) Sanitize a glm model}
\usage{
\method{sanitize_model}{glm}(model, trt, ...)
}
\arguments{
\item{model}{a \link[stats]{glm} with binomial family canonical link.}

\item{trt}{the name of the treatment variable on the right-hand side of the formula in a \link[stats]{glm}.}

\item{...}{ignored.}
}
\value{
if model is non-compliant will throw warnings or errors.
}
\description{
(internal) Sanitize a glm model
}
\examples{
trial01$trtp <- factor(trial01$trtp)
fit1 <- glm(aval ~ trtp + bl_cov, family = "binomial", data = trial01)
fit1 <- sanitize_model(fit1, "trtp")

}
\keyword{internal}
