% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_distr}
\alias{create_distr}
\title{General function to create a distribution.}
\usage{
create_distr(name, id, value = NA, lower = NA, upper = NA, ...)
}
\arguments{
\item{name}{the distribution name. Valid
names can be found in \code{get_distr_names}}

\item{id}{the distribution's ID}

\item{value}{the initial value for the MCMC}

\item{lower}{the lower bound, the lowest possible value}

\item{upper}{an upper limit of the uniform distribution.
If the upper limits needs to be infinity, set \code{upper} to \code{Inf}.}

\item{...}{specific distribution parameters}
}
\value{
a distribution
}
\description{
General function to create a distribution.
}
\note{
Prefer using the
  named functions
  \code{\link{create_beta_distr}},
  \code{\link{create_exp_distr}},
  \code{\link{create_gamma_distr}},
  \code{\link{create_inv_gamma_distr}},
  \code{\link{create_laplace_distr}},
  \code{\link{create_log_normal_distr}},
  \code{\link{create_normal_distr}},
  \code{\link{create_one_div_x_distr}},
  \code{\link{create_poisson_distr}}
  and \code{\link{create_uniform_distr}}

See
  \code{\link{create_beta_distr}},
  \code{\link{create_exp_distr}},
  \code{\link{create_gamma_distr}},
  \code{\link{create_inv_gamma_distr}},
  \code{\link{create_laplace_distr}},
  \code{\link{create_log_normal_distr}},
  \code{\link{create_normal_distr}},
  \code{\link{create_one_div_x_distr}},
  \code{\link{create_poisson_distr}}
  and \code{\link{create_uniform_distr}}
  for examples how to use those distributions
}
\examples{
# Use any distribution
distr <- create_beta_distr()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = create_yule_tree_prior(
    birth_rate_distr = distr
  )
)
file.remove(beast2_input_file)
}
\author{
Richèl J.C. Bilderbeek
}
