% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_prior_to_xml_lh_distr.R
\name{mrca_prior_to_xml_lh_distr}
\alias{mrca_prior_to_xml_lh_distr}
\title{Converts an MRCA prior to the \code{branchRateModel} section of the
XML as text.}
\usage{
mrca_prior_to_xml_lh_distr(
  inference_model,
  mrca_prior = "deprecated",
  has_non_strict_clock_model = "deprecated"
)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{has_non_strict_clock_model}{boolean to indicate that the is
already at least one non-strict (i.e. relaxed log-normal) clock model}
}
\value{
lines of XML text
}
\description{
This function will be called if and only if there are MRCA priors
and only supports strict clocks at the moment.
}
\examples{
 # <distribution id="posterior" spec="util.CompoundDistribution">
 #     <distribution id="prior" spec="util.CompoundDistribution">
 #     </distribution>
 #     <distribution id="likelihood" ...>
 #       HERE, where the ID of the distribution is 'likelihood'
 #     </distribution>
 # </distribution>
}
\author{
Richèl J.C. Bilderbeek
}
