% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_distr.R
\name{create_normal_distr}
\alias{create_normal_distr}
\alias{create_distr_normal}
\title{Create an normal distribution}
\usage{
create_normal_distr(id = NA, mean = 0, sigma = 1)
}
\arguments{
\item{id}{the distribution's ID}

\item{mean}{the mean parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_mean_param}}}

\item{sigma}{the sigma parameter,
a numeric value.
For advanced usage, use the structure
as returned by \code{\link{create_sigma_param}}}
}
\value{
a normal distribution
}
\description{
Create an normal distribution
}
\examples{
  normal_distr <- create_normal_distr()

  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    tree_prior = create_yule_tree_prior(
      birth_rate_distr = normal_distr
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_distr}} shows an overview
  of all supported distributions
}
\author{
Richèl J.C. Bilderbeek
}
