% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_priors_from_names.R
\name{create_tree_priors_from_names}
\alias{create_tree_priors_from_names}
\title{Create tree priors from their names}
\usage{
create_tree_priors_from_names(tree_prior_names)
}
\arguments{
\item{tree_prior_names}{one or more names of a tree prior,
must be a name among those returned by \code{\link{get_tree_prior_names}}}
}
\value{
a tree prior, as can be created by using \link{create_tree_prior}
}
\description{
Create tree priors from their names
}
\examples{
  names <- get_tree_prior_names()
  tree_priors <- create_tree_priors_from_names(names)

  for (i in seq_along(names)) {
    testthat::expect_equal(names[i], tree_priors[[i]]$name)
  }
}
\seealso{
Use \link{create_tree_prior} to create a tree prior
}
\author{
Richèl J.C. Bilderbeek
}
