% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_random_fasta.R
\name{create_random_fasta}
\alias{create_random_fasta}
\title{Create a random FASTA file}
\usage{
create_random_fasta(
  n_taxa,
  sequence_length,
  fasta_filename,
  taxa_name_ext = ""
)
}
\arguments{
\item{n_taxa}{The number of taxa}

\item{sequence_length}{a DNA sequence length, in base pairs}

\item{fasta_filename}{a FASTA filename.}

\item{taxa_name_ext}{the extension of the taxa names}
}
\value{
Nothing, creates a FASTA file
}
\description{
Create a random FASTA file
}
\examples{
check_empty_beaustier_folders()

fasta_filename <- get_beastier_tempfilename()
create_random_fasta(
  n_taxa = 5,
  sequence_length = 20,
  fasta_filename = fasta_filename
)
file.remove(fasta_filename)

remove_beaustier_folders()
check_empty_beaustier_folders()
}
\author{
Richèl J.C. Bilderbeek
}
