#' Get a list with the full paths of all
#' BEAST2 example filenames
#' @inheritParams default_params_doc
#' @return a list with the full paths of all
#'   BEAST2 example filenames
#' @export
get_beast2_example_filenames <- function(
  beast2_folder = get_default_beast2_folder()
) {
  beast2_subfolder <- file.path(beast2_folder, "beast")
  testit::assert(dir.exists(beast2_subfolder))
  examples_folder <- file.path(beast2_subfolder, "examples")
  testit::assert(dir.exists(examples_folder))
  list.files(
    path = examples_folder,
    full.names = TRUE,
    recursive = TRUE
  )
}
