% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_rng_seed.R
\name{check_rng_seed}
\alias{check_rng_seed}
\title{Check if the input is a valid RNG seed.}
\usage{
check_rng_seed(rng_seed)
}
\arguments{
\item{rng_seed}{the random number generator seed of the BEAST2 run.
Must be a non-zero positive integer value or \link{NA}.
If \code{rng_seed} is \link{NA}, BEAST2 will pick a random seed}
}
\description{
Will \link{stop} if not.
}
\examples{
  library(testthat)

  expect_silent(check_rng_seed(1))
  expect_silent(check_rng_seed(2))
  expect_silent(check_rng_seed(NA))

  expect_error(check_rng_seed(0))
  expect_error(check_rng_seed(-1))
  expect_error(check_rng_seed("nonsense"))
  expect_error(check_rng_seed(c(1, 2)))
  expect_error(check_rng_seed(c()))
  expect_error(check_rng_seed(NULL))
}
\author{
Richèl J.C. Bilderbeek
}
