% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-httpRouters.R
\name{httpPOST}
\alias{httpPOST}
\title{POST-binding middleware}
\usage{
httpPOST(beakr, path = NULL, FUN = NULL)
}
\arguments{
\item{beakr}{\code{Beakr} instance or \code{NULL}.}

\item{path}{String representing a path for which the middleware
function is invoked.}

\item{FUN}{Middleware function to be invoked.}
}
\value{
A \code{Beakr} instance with added middleware.
}
\description{
Routes HTTP POST requests to the specified path with the
specified callback functions or middleware.
}
\examples{
\dontrun{
# Create an new Beakr instance
beakr <- newBeakr()

# Create a simple beakr pipeline
beakr \%>\%
  httpPOST("/", function(req, res, err) {
    return("Successful POST request!\n")
  }) \%>\%
  listen(host = '127.0.0.1', port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# IN A TERMINAL:
#  curl -X POST http://127.0.0.1:25118/
# > Successful POST request!
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
