% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StopWordPipe.R
\name{StopWordPipe}
\alias{StopWordPipe}
\title{Class to find and/or remove the stop words on the data field of an Instance}
\description{
\code{\link{StopWordPipe}} class is responsible for detecting
the existing stop words in the \strong{data} field of each \code{\link{Instance}}.
Identified stop words are stored inside the \strong{contraction} field of
\code{\link{Instance}} class. Moreover if needed, is able to perform inline
stop words removement.
}
\section{Details}{

\code{\link{StopWordPipe}} class requires the resource files (in json format)
containing the list of stop words. To this end, the language of the text
indicated in the \emph{propertyLanguageName} should be contained in the
resource file name (ie. xxx.json where xxx is the value defined in the
\emph{propertyLanguageName} ). The location of the resources should be
defined in the \strong{"resources.stopwords.path"} field of
\emph{\link{bdpar.Options}} variable.
}

\section{Note}{

\code{\link{StopWordPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{bdpar.Options}},
         \code{\link{ContractionPipe}}, \code{\link{File2Pipe}},
         \code{\link{FindEmojiPipe}}, \code{\link{FindEmoticonPipe}},
         \code{\link{FindHashtagPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{ResourceHandler}},
         \code{\link{SlangPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{StopWordPipe}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StopWordPipe-new}{\code{StopWordPipe$new()}}
\item \href{#method-StopWordPipe-pipe}{\code{StopWordPipe$pipe()}}
\item \href{#method-StopWordPipe-findStopWord}{\code{StopWordPipe$findStopWord()}}
\item \href{#method-StopWordPipe-removeStopWord}{\code{StopWordPipe$removeStopWord()}}
\item \href{#method-StopWordPipe-getPropertyLanguageName}{\code{StopWordPipe$getPropertyLanguageName()}}
\item \href{#method-StopWordPipe-getResourcesStopWordsPath}{\code{StopWordPipe$getResourcesStopWordsPath()}}
\item \href{#method-StopWordPipe-setResourcesStopWordsPath}{\code{StopWordPipe$setResourcesStopWordsPath()}}
\item \href{#method-StopWordPipe-clone}{\code{StopWordPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{StopWordPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$new(
  propertyName = "stopWord",
  propertyLanguageName = "language",
  alwaysBeforeDeps = list("GuessLanguagePipe"),
  notAfterDeps = list("AbbreviationPipe"),
  removeStopWords = TRUE,
  resourcesStopWordsPath = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeStopWords}}{A \code{\link{logical}} value. Indicates if
the stop words are removed or not.}

\item{\code{resourcesStopWordsPath}}{A \code{\link{character}} value. Path
of resource files (in json format) containing the stop words.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the stop words. The stop words found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-findStopWord"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-findStopWord}{}}}
\subsection{Method \code{findStopWord()}}{
Checks if the stop word is in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$findStopWord(data, stopWord)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where stop word
will be searched.}

\item{\code{stopWord}}{A \code{\link{character}} value. Indicates the
stop word to find.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{logical}} value depending on whether the
stop word is in the data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-removeStopWord"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-removeStopWord}{}}}
\subsection{Method \code{removeStopWord()}}{
Removes the \emph{stop word} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$removeStopWord(stopWord, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{stopWord}}{A \code{\link{character}} value. Indicates the
stop word to remove.}

\item{\code{data}}{A \code{\link{character}} value. The text where stop word
will be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the stop words removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-getPropertyLanguageName"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-getPropertyLanguageName}{}}}
\subsection{Method \code{getPropertyLanguageName()}}{
Gets the name of property language.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$getPropertyLanguageName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of name of property language.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-getResourcesStopWordsPath"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-getResourcesStopWordsPath}{}}}
\subsection{Method \code{getResourcesStopWordsPath()}}{
Gets the path of stop words resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$getResourcesStopWordsPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path of stop words resources.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-setResourcesStopWordsPath"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-setResourcesStopWordsPath}{}}}
\subsection{Method \code{setResourcesStopWordsPath()}}{
Sets the path of stop words resources.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$setResourcesStopWordsPath(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. The new value of the path of
stop words resources.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StopWordPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StopWordPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StopWordPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
