% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variables.R
\name{get_variables}
\alias{get_variables}
\title{Get variable id codes.}
\usage{
get_variables(
  subjectId,
  level = NULL,
  year = NULL,
  sort = c("id", "-id", "subjectId", "-subjectId"),
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{subjectId}{A subject id code. If not specified returns all top level subjects.
Use \code{\link{search_subjects}} or \code{\link{get_subjects}} to get subject id.}

\item{level}{A number from 0 to 6, filters the returned unit by its level.
If \code{NULL} (default) no level filters apply. Use \code{\link{get_levels}} to find more info.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{sort}{A type of sorting, "id" (default), "-id", "subjectId", "-subjectId"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve variables for given subjectId.
}
\details{
Variables for specified subject optionally filtered by \code{level} and \code{year}.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
    get_variables("P2425")
}
}
\keyword{search}
\keyword{utilities}
\keyword{variables}
