% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_unit.R
\name{get_data_by_unit}
\alias{get_data_by_unit}
\title{Get data by unit Id's from BDL API}
\usage{
get_data_by_unit(
  unitId,
  varId,
  year = NULL,
  type = c("code", "label"),
  aggregateId = NULL,
  lang = c("pl", "en"),
  ...
)
}
\arguments{
\item{unitId}{A single 12 character NUTS id code or vector of  multiple unit id 
codes. If multiple unit codes are used, some columns are not available.
Use \code{\link{search_units}} or \code{\link{get_units}} to find unit id code.}

\item{varId}{A vector of variable Id's.Use \code{\link{search_variables}} or
\code{\link{get_variables}} to find variable id code.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{type}{A type of variables returned, "code" (default), "label"}

\item{aggregateId}{An aggregate id. Use \code{\link{get_aggregates}} for more info.}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve data for given units from BDL with specified format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be filtered with arguments. To get JSON data from specified
  directory with custom filters use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
   get_data_by_unit(unitId = "023200000000", varId =  "3643")
   get_data_by_unit(unitId = "023200000000", varId =  c("3643", "2137", "148190"),
                          type = "label")
   
   # Multi variable download
   get_data_by_unit(unitId = c("023200000000", "020800000000"), 
                          varId =  c("3643", "2137", "148190"))
}
}
\keyword{database}
\keyword{utilities}
