% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_checks.R
\name{taxo_level}
\alias{taxo_level}
\title{Clean data based on lower taxon level}
\usage{
taxo_level(bddata, res = "SPECIES")
}
\arguments{
\item{bddata}{Bio diversity data in a data frame}

\item{res}{The low rank of species required}
}
\description{
Clean data based on lower taxon level
}
\section{samplePassData}{

When resolution is Species, Subspecies and Species will pass.
}

\section{sampleFailData}{

When resolution is Species, Family or Genus or any lower ranks will fail.
}

\section{targetDWCField}{

taxonRank
}

\section{checkCategory}{

taxonomic
}

\examples{

if(interactive()){

library(rgbif)
occdat <- occ_data(
  country = 'AU', # Country code for australia
  classKey = 359, # Class code for mammalia
  limit = 50 # Get only 50 records
)
myData <- occdat$data

responses <- taxo_level(myData, 'SPECIES')

}

}
