% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_year_from_eventDate.R
\name{bdc_year_from_eventDate}
\alias{bdc_year_from_eventDate}
\title{Extract year from eventDate}
\usage{
bdc_year_from_eventDate(data, eventDate = "eventDate")
}
\arguments{
\item{data}{A data frame containing a column with event date information.}

\item{eventDate}{Numeric or date. The column with event date information.}
}
\value{
A data.frame containing the column "year". Year information is
returned only if "eventDate" can be unambiguously interpretable from
"eventDate". Years in the future (e.g., 2050) are returned as NA as well as
years before 1600, which is the lower limit for collecting dates of
biological specimens.
}
\description{
This function extracts a four-digit year from unambiguously interpretable
collecting dates.
}
\examples{
collection_date <- c(
  NA, "31/12/2015", "2013-06-13T00:00:00Z", "2019-05-20",
  "", "2013", "0001-01-00", "20", "1200"
)
x <- data.frame(collection_date)

bdc_year_from_eventDate(data = x, eventDate = "collection_date")

}
\seealso{
Other time: 
\code{\link{bdc_eventDate_empty}()},
\code{\link{bdc_year_outOfRange}()}
}
\concept{time}
