% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_by_poly.R
\name{raster_by_poly}
\alias{raster_by_poly}
\title{Overlay a SpatialPolygonsDataFrame or sf polygons layer on a raster layer
and clip the raster to each polygon. Optionally done in parallel}
\usage{
raster_by_poly(
  raster_layer,
  poly,
  poly_field,
  summarize = FALSE,
  parallel = FALSE
)
}
\arguments{
\item{raster_layer}{the raster layer}

\item{poly}{a \code{SpatialPolygonsDataFrame} layer or \code{sf} layer}

\item{poly_field}{the field on which to split the \code{SpatialPolygonsDataFrame}}

\item{summarize}{Should the function summarise the raster values in each
polygon to a vector? Default \code{FALSE}}

\item{parallel}{process in parallel? Default \code{FALSE}. If \code{TRUE}, it is up to
the user to call \code{\link[future:plan]{future::plan()}} (or set \link[future:future.options]{options})
to specify what parallel strategy to use.}
}
\value{
a list of \code{RasterLayers} if \code{summarize = FALSE} otherwise a list of
vectors.
}
\description{
Overlay a SpatialPolygonsDataFrame or sf polygons layer on a raster layer
and clip the raster to each polygon. Optionally done in parallel
}
