% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcvusMAR-asyVAR.R
\name{asyVarVUS}
\alias{asyVarVUS}
\title{Asymptotic variance estimation for VUS}
\usage{
asyVarVUS(obj_vus, T, Dvec, V = NULL, rhoEst = NULL, piEst = NULL,
  BOOT = FALSE, nR = 250, parallel = FALSE, ncpus = ifelse(parallel,
  detectCores()/2, NULL))
}
\arguments{
\item{obj_vus}{a result of a call to \code{\link{vus}}.}

\item{T}{a numeric vector containing the diagnostic test values. \code{NA} values of \code{T} are not accepted.}

\item{Dvec}{a n * 3  binary matrix with three columns, corresponding to the three classes of the disease status. In row i, 1 in column j indicates that the i-th subject belongs to class j, with j = 1, 2, 3. A row of \code{NA} values indicates a non-verified subject.}

\item{V}{a binary vector containing the verification status (1 verified, 0 not verified).}

\item{rhoEst}{a result of a call to \code{\link{rhoMLogit}} of \code{\link{rhoKNN}} to fit the disease model.}

\item{piEst}{a result of a call to \code{\link{psglm}} to fit the verification model.}

\item{BOOT}{a logical value. Default = \code{FALSE}. If set to \code{TRUE}, a bootstrap resampling is employed to estimate the asymptotic variance of the bias-corrected VUS estimators.}

\item{nR}{the number of bootstrap replicates, which is used for FULL or KNN estimators, or option \code{BOOT = TRUE}. The defaut is 250.}

\item{parallel}{a logical value. If \code{TRUE}, a parallel computing is employed in the bootstrap resampling process.}

\item{ncpus}{number of processes to be used in parallel computing. Default is half of available cores.}
}
\value{
\code{asyVarVUS} returns a estimated value of the asymptotic variance.
}
\description{
\code{asyVarVUS} computes the asymptotic variance of full data (FULL) and bias-corrected estimators (i.e. full imputation, mean score imputation, inverse probability weighting, semiparametric efficient and K nearest neighbor) of VUS.
}
\details{
For the FULL and K nearest neighbor estimators, a bootstrap resampling process is employed to obtain their asymptotic variance.

For the full imputation, mean score imputation, inverse probability weighting and semiparametric efficient estimators of VUS, the asymptotic variances are computed by using the explicit form. Furthermore, a bootstrap procedure is also available, useful in case of small sample sizes.
}
\examples{
data(EOC)

# Preparing the missing disease status
Dna <- preDATA(EOC$D, EOC$CA125)
Dfact.na <- Dna$D
Dvec.na <- Dna$Dvec

rho.out <- rhoMLogit(Dfact.na ~ CA125 + CA153 + Age, data = EOC, test = TRUE)
pi.out <- psglm(V ~ CA125 + CA153 + Age, data = EOC, test = TRUE)
vus.spe <- vus("spe", T = EOC$CA125, Dvec = Dvec.na, V = EOC$V, rhoEst = rho.out,
               piEst = pi.out, ci = FALSE)
var.spe <- asyVarVUS(vus.spe, T = EOC$CA125, Dvec = Dvec.na, V = EOC$V,
                     rhoEst = rho.out, piEst = pi.out)

\dontrun{
var.bst.spe <- asyVarVUS(vus.spe, T = EOC$CA125, Dvec = Dvec.na, V = EOC$V,
                         rhoEst = rho.out, piEst = pi.out, BOOT = TRUE,
                         parallel = TRUE)
}


}
\references{
To Duc, K., Chiogna, M. and Adimari, G. (2016)
Bias-corrected methods for estimating the receiver operating characteristic surface of continuous diagnostic tests.
\emph{Electronic Journal of Statistics}, \bold{10}, 3063-3113.
}

