% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify.R
\name{stratify}
\alias{stratify}
\title{Stratify raw Breeding Bird Survey data}
\usage{
stratify(
  by = NULL,
  sample_data = FALSE,
  bbs_data = NULL,
  lump_species_forms = TRUE,
  quiet = FALSE,
  stratify_by = NULL
)
}
\arguments{
\item{by}{String argument of stratification type.
Options are "state", "bcr", "latlong", "bbs_cws", "bbs_usgs"}

\item{sample_data}{Should just sample data (just Pacific Wren) be used?
Defaults to FALSE.}

\item{bbs_data}{Raw BBS data saved as a list of 3 data frames.
Not necessary if you have already run \code{fetch_bbs_data}}

\item{lump_species_forms}{Logical, default is TRUE, indicating that for
species with multiple forms, the "unidentified" form is replaced by
the sum of observations for all forms (including the original unidentified obs).
The underlying BBS database includes separate data for each form,
and these separate forms are retained with their original names.
The original unidentified category for observations that were not specific to
a particular form are replaced by the combined observations. If the user
wishes to keep the unidentified form separate, this can be set to FALSE}

\item{quiet}{Should progress bars be suppressed?}

\item{stratify_by}{Deprecated in favour of 'by'}
}
\value{
Large list (3 elements) consisting of:
  \item{bird_strat}{Dataframe of stratified bird data}
  \item{route_strat}{Dataframe of stratified route data}
  \item{species_strat}{Dataframe of stratified species data}
  \item{by}{Argument used for stratification}
}
\description{
Assigns each bird count data point and each route a strata
  based on its geographic location and the stratification
  as specified by the user.
}
\examples{

# Toy examples using Pacific Wren sample data

# Stratify by CWS USGS stratifications
data_strat <- stratify(by = "bbs_usgs", sample_data = TRUE)

# Stratify by Bird Conservation Regions only
data_strat <- stratify(by = "bcr", sample_data = TRUE)

# Stratify by CWS BBS stratifications
data_strat <- stratify(by = "bbs_cws", sample_data = TRUE)

# Stratify by State/Province/Territory only
data_strat <- stratify(by = "state", sample_data = TRUE)

# Stratify by blocks of 1 degree of latitude X 1 degree of longitude
data_strat <- stratify(by = "latlong", sample_data = TRUE)

\donttest{
# Requires fetch_bbs_data() to have been run (takes about 10 minutes).

# Stratify the entire data set, may take a minute or so
data_strat <- stratify(by = "bbs_cws")
}
}
