% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerDesignPoints.R
\name{mlr_optimizers_design_points}
\alias{mlr_optimizers_design_points}
\alias{OptimizerDesignPoints}
\title{Optimization via Design Points}
\description{
\code{OptimizerDesignPoints} class that implements optimization w.r.t. fixed
design points. We simply search over a set of points fully specified by the
user. The points in the design are evaluated in order as given.

In order to support general termination criteria and parallelization, we
evaluate points in a batch-fashion of size \code{batch_size}. Larger batches mean
we can parallelize more, smaller batches imply a more fine-grained checking
of termination criteria.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_optimizers$get("design_points")
opt("design_points")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{batch_size}}{\code{integer(1)}\cr
Maximum number of configurations to try in a batch.}
\item{\code{design}}{\link[data.table:data.table]{data.table::data.table}\cr
Design points to try in search, one per row.}
}
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
library(data.table)
search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

codomain = ps(y = p_dbl(tags = "minimize"))

objective_function = function(xs) {
  list(y = as.numeric(xs)^2)
}

objective = ObjectiveRFun$new(
  fun = objective_function,
  domain = domain,
  codomain = codomain)

instance = OptimInstanceSingleCrit$new(
  objective = objective,
  search_space = search_space,
  terminator = trm("evals", n_evals = 10))

design = data.table(x = c(0, 1))

optimizer = opt("design_points", design = design)

# Modifies the instance by reference
optimizer$optimize(instance)

# Returns best scoring evaluation
instance$result

# Allows access of data.table of full path of all evaluations
as.data.table(instance$archive)
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerDesignPoints}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OptimizerDesignPoints-new}{\code{OptimizerDesignPoints$new()}}
\item \href{#method-OptimizerDesignPoints-clone}{\code{OptimizerDesignPoints$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-format'><code>bbotk::Optimizer$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="help"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-help'><code>bbotk::Optimizer$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-optimize'><code>bbotk::Optimizer$optimize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print"><a href='../../bbotk/html/Optimizer.html#method-Optimizer-print'><code>bbotk::Optimizer$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerDesignPoints-new"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerDesignPoints-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerDesignPoints$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OptimizerDesignPoints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OptimizerDesignPoints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerDesignPoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
