% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_optimizers.R
\docType{data}
\name{mlr_optimizers}
\alias{mlr_optimizers}
\title{Dictionary of Optimizer}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}
\description{
A simple \link[mlr3misc:Dictionary]{mlr3misc::Dictionary} storing objects of class \link{Optimizer}.
Each optimizer has an associated help page, see \code{mlr_optimizer_[id]}.

This dictionary can get populated with additional optimizer by add-on packages.

For a more convenient way to retrieve and construct optimizer, see \code{\link[=opt]{opt()}}/\code{\link[=opts]{opts()}}.
}
\section{Methods}{

See \link[mlr3misc:Dictionary]{mlr3misc::Dictionary}.
}

\section{S3 methods}{

\itemize{
\item \code{as.data.table(dict, ..., objects = FALSE)}\cr
\link[mlr3misc:Dictionary]{mlr3misc::Dictionary} -> \code{\link[data.table:data.table]{data.table::data.table()}}\cr
Returns a \code{\link[data.table:data.table]{data.table::data.table()}} with fields "key", "label", "param_classes", "properties" and "packages" as columns.
If \code{objects} is set to \code{TRUE}, the constructed objects are returned in the list column named \code{object}.
}
}

\examples{
as.data.table(mlr_optimizers)
mlr_optimizers$get("random_search")
opt("random_search")
}
\seealso{
Sugar functions: \code{\link[=opt]{opt()}}, \code{\link[=opts]{opts()}}
}
\concept{Dictionary}
\concept{Optimizer}
\keyword{datasets}
