% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.qw.R
\name{as.qw}
\alias{as.qw}
\alias{as.qw,numeric,character,character,numeric,character,character,character,character,character,missing-method}
\alias{as.qw,numeric,character,character,numeric,character,character,character,character,character,numeric-method}
\title{Water-quality Data Conversion}
\usage{
as.qw(
  values,
  remark.codes,
  value.codes,
  reporting.level,
  reporting.method,
  reporting.units,
  analyte.method,
  analyte.name,
  unique.code,
  value2
)

\S4method{as.qw}{numeric,character,character,numeric,character,character,character,character,character,missing}(
  values,
  remark.codes,
  value.codes,
  reporting.level,
  reporting.method,
  reporting.units,
  analyte.method,
  analyte.name,
  unique.code,
  value2
)

\S4method{as.qw}{numeric,character,character,numeric,character,character,character,character,character,numeric}(
  values,
  remark.codes,
  value.codes,
  reporting.level,
  reporting.method,
  reporting.units,
  analyte.method,
  analyte.name,
  unique.code,
  value2
)
}
\arguments{
\item{values}{the uncensored values and optionally the censored values.}

\item{remark.codes}{the remarks codes: " " or "" indicated uncensored, "<"
indicates left-censoring, ">" indicates right censoring. The special remark
code "M" is created when the value is rounded to 0 by NWIS. In this case, the value 
is set to less than the reporting level if the reporting level is not the missing
value \code{NA}, otherwise the value is set to missing \code{NA} and "M" is
retained as the remark code. Other codes have a
special meaning that can be modified by \code{value.codes}.}

\item{value.codes}{special value qualifier codes. See Lorenz and others, 2014
for a description of these codes and the special \code{remark.codes}.}

\item{reporting.level}{the reporting level associated with each value. Note that
if the reporting level is not known, then \code{NA_real_} should be used instead
of using any arbitrary value.}

\item{reporting.method}{the method used to compute the reporting level. These
can be arbitrary codes, known only to the user.}

\item{reporting.units}{the reporting units. A few defined units such as
"mg/l" are recognized and used by the software.}

\item{analyte.method}{the method used to compute the concentration. These can
be arbitrary codes, known only to the user.}

\item{analyte.name}{the name of the analyte. A few names are recongnized such
as "chloride" and used by the software.}

\item{unique.code}{an arbitrary code identifying unique instances of data.
For data retreived from the US Geological Survey, this should be the 5-digit
parameter code.}

\item{value2}{for interval censored data, the upper value.}
}
\value{
An object of class "qw" that contains the numeric data in a
two-column matrix and the meta data as additional slot information.
}
\description{
Converts data and meta data to a water-quality data (\code{qw}) object:
various methods.
From smwrQW package.
}
\details{
Two methods for constructing water-quality data are defined in the current
version. The first method works well for un-, left-, and right-censored data where the 
remark code and value can completely define the numeric values. The second method works
for any censored data, including interval-censored data, where an upper and lower
range of values are required. For the second method, \code{values} is the lower limit
of the range and for left-censored data, may be either \code{-Inf}, \code{NA}, or \code{0}.
If \code{-Inf}, then the value is treated as strictly left-censored, otherwise, the 
lower limit is set to \code{0}, which corresponds to the traditional interpretation of
left-censored water-quality data. For the second method, \code{value2} is the upper
limit and for right-censored data will always be set to \code{Inf}.
}
\note{
The class "qw" is intended to be a flexible and user-friendly
way to store and manage water-quality data. The meta data that are stored
with the numeric and remark data are essential for unbiased statistical
analysis and for reducing other errors in interpretation or computation.\cr

Objects of class "qw" also have a slot named "rounding" that controls how the 
data are roudend when printed. That slot is an integer vector of length 2, the
first element is the maximum number of significant figures and the second is the
maximum number of decimal places to show. The default value used by \code{as.qw}
is c(2L,3L). It can be changed by specifically modifying the slot value.
}
\references{
Lorenz, D.L., in preparation
}
\keyword{internal}
\keyword{manip}
\keyword{methods}
