% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bic_to_bf.R
\name{bic_to_bf}
\alias{bic_to_bf}
\title{Convert BIC indices to Bayes Factors via the BIC-approximation method.}
\usage{
bic_to_bf(bic, denominator, log = FALSE)
}
\arguments{
\item{bic}{A vector of BIC values.}

\item{denominator}{The BIC value to use as a denominator (to test against).}

\item{log}{If \code{TRUE}, return the \code{log(BF)}.}
}
\value{
The Bayes Factors corresponding to the BIC values against the denominator.
}
\description{
The difference between two Bayesian information criterion (BIC) indices of
two models can be used to approximate Bayes factors via:
\cr
\deqn{BF_{10} = e^{(BIC_0 - BIC_1)/2}}{BF10 = exp((BIC0-BIC1)/2)}
}
\examples{
bic1 <- BIC(lm(Sepal.Length ~ 1, data = iris))
bic2 <- BIC(lm(Sepal.Length ~ Species, data = iris))
bic3 <- BIC(lm(Sepal.Length ~ Species + Petal.Length, data = iris))
bic4 <- BIC(lm(Sepal.Length ~ Species * Petal.Length, data = iris))

bic_to_bf(c(bic1, bic2, bic3, bic4), denominator = bic1)
}
\references{
Wagenmakers, E. J. (2007). A practical solution to the pervasive problems of
p values. Psychonomic bulletin & review, 14(5), 779-804
}
