% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction_summary.R
\name{prediction_summary}
\alias{prediction_summary}
\title{Posterior Predictive Summaries}
\usage{
prediction_summary(
  model,
  data,
  prob_inner = 0.5,
  prob_outer = 0.95,
  stable = FALSE
)
}
\arguments{
\item{model}{an rstanreg model object with quantitative y}

\item{data}{data frame including the variables in the model, both response y and predictors x}

\item{prob_inner}{posterior predictive interval probability (a value between 0 and 1)}

\item{prob_outer}{posterior predictive interval probability (a value between 0 and 1)}

\item{stable}{TRUE returns the number of absolute deviations and FALSE returns the standard deviations that observed y values fall from their predictive medians}
}
\value{
a tibble
}
\description{
Given a set of observed data including a quantitative response variable y 
and an rstanreg model of y, 
this function returns 4 measures of the posterior prediction quality.
Median absolute prediction error (mae) measures the typical difference between the observed y values and their posterior predictive medians (stable = TRUE) or means (stable = FALSE).
Scaled mae (mae_scaled) measures the typical number of absolute deviations (stable = TRUE) or standard deviations (stable = FALSE) that observed y values fall from their predictive medians (stable = TRUE) or means (stable = FALSE).
within_50 and within_90 report the proportion of observed y values that fall within their posterior prediction intervals, the probability levels of which are set by the user.
}
\examples{
example_data <- data.frame(x = sample(1:100, 20))
example_data$y <- example_data$x*3 + rnorm(20, 0, 5)
example_model <- rstanarm::stan_glm(y ~ x,  data = example_data)
prediction_summary(example_model, example_data, prob_inner = 0.6, prob_outer = 0.80, stable = TRUE)
}
