% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nec.R
\name{nec}
\alias{nec}
\title{nec}
\usage{
nec(object, posterior = FALSE, xform = NA, prob_vals = c(0.5, 0.025, 0.975))
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesnecfit}} returned by \code{\link{bnec}}.}

\item{posterior}{A \code{\link[base]{logical}} value indicating if the full
posterior sample of calculated nec values should be returned instead of
just the median and 95 credible intervals.}

\item{xform}{A function to apply to the returned estimated concentration
values.}

\item{prob_vals}{A vector indicating the probability values over which to
return the estimated nec value. Defaults to 0.5 (median) and 0.025 and
0.975 (95 percent credible intervals).}
}
\value{
A vector containing the estimated nec value, including upper and
lower 95\% credible interval bounds
(or other interval as specified by prob_vals).
}
\description{
Extracts the predicted nec value as desired from an object of class
\code{\link{bayesnecfit}} or \code{\link{bayesnecfit}}.
}
\examples{
library(bayesnec)
data(manec_example)
nec(manec_example)

}
\seealso{
\code{\link{bnec}}
}
