% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{fitted.bayesianVARs_bvar}
\alias{fitted.bayesianVARs_bvar}
\title{Simulate fitted/predicted historical values for an estimated VAR model}
\usage{
\method{fitted}{bayesianVARs_bvar}(object, error_term = TRUE, ...)
}
\arguments{
\item{object}{A \code{bayesianVARs_bvar} object estimated via \code{\link[=bvar]{bvar()}}.}

\item{error_term}{logical indicating whether to include the error term or
not.}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{bayesianVARs_fitted}.
}
\description{
Simulates the fitted/predicted (in-sample) values for an estimated VAR model.
}
\examples{
# Access a subset of the usmacro_growth dataset
data <- usmacro_growth[,c("GDPC1", "CPIAUCSL", "FEDFUNDS")]

# Estimate a model
mod <- bvar(data, sv_keep = "all", quiet = TRUE)

# Simulate predicted historical values including the error term.
pred <- fitted(mod, error_term = TRUE)

# Simulate fitted historical values not including the error term.
fit <- fitted(mod, error_term = FALSE)

# Visualize
plot(pred)
plot(fit)
}
