% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_swans.R
\name{find_swans}
\alias{find_swans}
\title{Find outlying "black swan" jumps in trends}
\usage{
find_swans(rotated_modelfit, threshold = 0.01, plot = FALSE)
}
\arguments{
\item{rotated_modelfit}{Output from \code{\link[=rotate_trends]{rotate_trends()}}.}

\item{threshold}{A probability threshold below which to flag trend events as
extreme}

\item{plot}{Logical: should a plot be made?}
}
\value{
Prints a ggplot2 plot if \code{plot = TRUE}; returns a data frame indicating the
probability that any given point in time represents a "black swan" event
invisibly.
}
\description{
Find outlying "black swan" jumps in trends
}
\examples{
set.seed(1)
s <- sim_dfa(num_trends = 1, num_ts = 3, num_years = 30)
s$y_sim[1, 15] <- s$y_sim[1, 15] - 6
plot(s$y_sim[1,], type = "o")
abline(v = 15, col = "red")
# only 1 chain and 250 iterations used so example runs quickly:
m <- fit_dfa(y = s$y_sim, num_trends = 1, iter = 50, chains = 1, nu_fixed = 2)
r <- rotate_trends(m)
p <- plot_trends(r) #+ geom_vline(xintercept = 15, colour = "red")
print(p)
# a 1 in 1000 probability if was from a normal distribution:
find_swans(r, plot = TRUE, threshold = 0.001)

}
\references{
Anderson, S.C., Branch, T.A., Cooper, A.B., and Dulvy, N.K. 2017.
Black-swan events in animal populations. Proceedings of the National Academy
of Sciences 114(12): 3252–3257. https://doi.org/10.1073/pnas.1611525114
}
