% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmcPotts.R
\name{mcmcPottsNoData}
\alias{mcmcPottsNoData}
\title{Simulate pixel labels using chequerboard Gibbs sampling.}
\usage{
mcmcPottsNoData(beta, k, neighbors, blocks, niter = 1000, random = TRUE)
}
\arguments{
\item{beta}{The inverse temperature parameter of the Potts model.}

\item{k}{The number of unique labels.}

\item{neighbors}{A matrix of all neighbors in the lattice, one row per pixel.}

\item{blocks}{A list of pixel indices, dividing the lattice into independent blocks.}

\item{niter}{The number of iterations of the algorithm to perform.}

\item{random}{Whether to initialize the labels using random or deterministic starting values.}
}
\value{
A list containing the following elements:
\describe{
  \item{\code{alloc}}{An n by k matrix containing the number of times that pixel i was allocated to label j.}
  \item{\code{z}}{An \code{(n+1)} by k matrix containing the final sample from the Potts model after niter iterations of chequerboard Gibbs.}
  \item{\code{sum}}{An \code{niter} by 1 matrix containing the sum of like neighbors, i.e. the sufficient statistic of the Potts model, at each iteration.}
  }
}
\description{
Simulate pixel labels using chequerboard Gibbs sampling.
}
\examples{
# Swendsen-Wang for a 2x2 lattice
neigh <- matrix(c(5,2,5,3,  1,5,5,4,  5,4,1,5,  3,5,2,5), nrow=4, ncol=4, byrow=TRUE)
blocks <- list(c(1,4), c(2,3))
res.Gibbs <- mcmcPottsNoData(0.7, 3, neigh, blocks, niter=200)
res.Gibbs$z
res.Gibbs$sum[200]
}
\seealso{
\code{\link[PottsUtils]{BlocksGibbs}}
}
