% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{L}
\alias{L}
\title{Lag function for autoregressive models}
\usage{
L(x, k = 1, id = NULL)
}
\arguments{
\item{x}{numeric vector}

\item{k}{integer vector of lagged variables to create}

\item{id}{optional identification number for each subject}
}
\value{
numeric vector or matrix of the lagged variable(s)
}
\description{
Creates lagged variables for use with \code{bayesGAM}, including the functionality
to create lags for each specified subject if desired. The input data must be pre-
sorted according by time, and within each subject id if specified.
}
\examples{
x <- rnorm(20)
id <- rep(1:4, each=5)
L(x, 1:2, id)

# autoregressive
ar.ols(lh, demean = FALSE, intercept=TRUE, order=1)
f <- bayesGAM(lh ~ L(lh), family=gaussian)
coef(f)
}
\references{
Zeileis A (2019). dynlm: Dynamic Linear Regression. R package version 0.3-6
}
