% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tps.R
\name{np}
\alias{np}
\title{Creates design matrices for univariate and bivariate applications}
\usage{
np(x1, x2 = NULL, num_knots = NULL, knots = NULL, basis = "tps", degree = 3)
}
\arguments{
\item{x1}{numeric vector}

\item{x2}{optional vector for bivariate non-parametric function}

\item{num_knots}{optional number of knots}

\item{knots}{optional numeric vector of knots}

\item{basis}{character vector for basis function.  \code{tps} for thin-plate spline and \code{trunc.poly} for truncated polynomial}

\item{degree}{for truncated polynomial basis function}
}
\value{
list with the following elements:
\itemize{
\item \code{X} parametric design matrix
\item \code{Z} non-parametric design matrix
\item \code{knots} numeric vector of knots for the model
\item \code{Xnms} names of parameters passed to \code{np}
\item \code{basis} selected basis function
\item \code{degree} degree for truncated polynomial basis function
}
}
\description{
\code{np} accepts one or two numeric vectors of equal length as inputs. From these inputs, univariate or bivariate smoothing design matrices are produced. Currently available basis functions are truncated polynomials and thin plate splines.
When bivariate smoothing is selected, \code{np} calls \code{\link{create_bivariate_design}}.
}
\examples{
x1 <- rnorm(100)
res <- np(x1, num_knots=10, basis="trunc.poly", degree=2)
res
}
\references{
Ruppert, David, Matt P. Wand, and Raymond J. Carroll. \emph{Semiparametric Regression}. No. 12. Cambridge university press, 2003. Section 5.6.

Matt Wand (2018). SemiPar: Semiparametric Regression. R package version 1.0-4.2.
}
