% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{predict.bayesDccGarch}
\alias{predict.bayesDccGarch}
\alias{predict}
\title{Bayesian forecast for volatilities and coditional correlations}
\usage{
\method{predict}{bayesDccGarch}(object, ..., n_ahead = 5, bayes = F)
}
\arguments{
\item{object}{a bayesDccGarch object}

\item{...}{default argument of predict function, not used}

\item{n_ahead}{number of steps ahead forecast}

\item{bayes}{a boolean. If True, then the forecast is calculated as being the average of the forecasts across all states in the Markov chain (much slower). If False then predictions are calculated using estimation parameters (much faster).}
}
\value{
A list with elements \code{H} and \code{R}
}
\description{
Bayesian forecast for volatilities and coditional correlations
}
\examples{
\donttest{
out = bayesDccGarch(DaxCacNik)
predict.bayesDccGarch(out, n_ahead=5)
}
}
\references{
Engle, R.F. and Sheppard, K. Theoretical and empirical properties of dynamic conditional correlation multivariate GARCH, 2001, NBER Working Paper.
}
