% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TableThemes.R
\name{getSimpleColoredTblTheme}
\alias{getSimpleColoredTblTheme}
\title{Get a simple coloured theme.}
\usage{
getSimpleColoredTblTheme(parentTable, themeName = "coloredTheme", colors,
  fontName)
}
\arguments{
\item{parentTable}{Owning table.}

\item{themeName}{The name to use as the new theme name.}

\item{colors}{The set of colours to use when generating the theme (see the Styling vignette for details).}

\item{fontName}{The name of the font to use, or a comma separated list (for font-fall-back).}
}
\value{
A TableStyles object.
}
\description{
Get a simple coloured theme that can be used to style a table into a custom colour scheme.
}
\examples{
orangeColors <- list(
  headerBackgroundColor = "rgb(237, 125, 49)",
  headerColor = "rgb(255, 255, 255)",
  cellBackgroundColor = "rgb(255, 255, 255)",
  cellColor = "rgb(0, 0, 0)",
  totalBackgroundColor = "rgb(248, 198, 165)",
  totalColor = "rgb(0, 0, 0)",
  borderColor = "rgb(198, 89, 17)"
)
library(basictabler)
tbl <- qtbl(data.frame(a=1:2, b=3:4))
tbl$theme <- getSimpleColoredTblTheme(parentTable=tbl,
    colors=orangeColors, fontName="Garamond, arial")
tbl$renderTable()
}
