% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickTable.R
\name{qhtbl}
\alias{qhtbl}
\title{Quickly render a basic table in HTML.}
\usage{
qhtbl(dataFrameOrMatrix, columnNamesAsColumnHeaders = TRUE,
  explicitColumnHeaders = NULL, rowNamesAsRowHeaders = FALSE,
  firstColumnAsRowHeaders = FALSE, explicitRowHeaders = NULL,
  columnFormats = NULL, ...)
}
\arguments{
\item{dataFrameOrMatrix}{The data frame or matrix containing the data to be
displayed in the table.}

\item{columnNamesAsColumnHeaders}{TRUE to use the data frame column names
as the column headers in the table.}

\item{explicitColumnHeaders}{A character vector of column headers.}

\item{rowNamesAsRowHeaders}{TRUE to use the data frame row names as the
row headers in the table.}

\item{firstColumnAsRowHeaders}{TRUE to use the first column in the data
frame as row headings.}

\item{explicitRowHeaders}{A character vector of row headers.}

\item{columnFormats}{A list containing format specifiers, each of which is
either an sprintf() character value, a list of format() arguments or an
R function that provides custom formatting logic.}

\item{...}{Additional arguments, currently only argumentCheckMode.}
}
\value{
A basic table.
}
\description{
The \code{qhpvt} function renders a basic table as a HTML widget with
one line of R.
}
\examples{
qhtbl(head(bhmsummary))
qhtbl(bhmsummary[1:5, c("GbttWeekDate", "Origin", "Destination", "TrainCount",
  "OnTimeArrivals")])
qhtbl(bhmsummary[1:5, c("GbttWeekDate", "Origin", "Destination", "TrainCount",
  "OnTimeArrivals")], columnNamesAsColumnHeaders=FALSE,
  explicitColumnHeaders=c("Week", "From", "To", "Trains", "On-Time"))

}
